import { world, BlockPermutation } from '@minecraft/server'

const blockStates = new Map()

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:araucaria_trapdoor', {
        onPlayerInteract(e) {
            const { block, player } = e;
            const equipment = player.getComponent('equippable')
            const selectedItem = equipment.getEquipment('Mainhand')
            const currentState = block.permutation.getState('v360:open')
            const newOpenState = !currentState
            const newPermutation = BlockPermutation.resolve(block.typeId, {
                ...block.permutation.getAllStates(),
                'v360:open': newOpenState
            })
            block.setPermutation(newPermutation)
            const sound = currentState ? 'open.wooden_trapdoor' : 'close.wooden_trapdoor'
            player.playSound(sound)
            if (selectedItem?.typeId === 'minecraft:water_bucket') {
                player.playSound('bucket.empty_water')
                if (player.getGameMode() !== "creative") {
                    equipment.setEquipment('Mainhand', new ItemStack('minecraft:bucket', 1));
                }
            }
            if (block.typeId === 'v360:araucaria_trapdoor' && selectedItem?.typeId === 'minecraft:water_bucket') {
                const currentStates = block.permutation.getAllStates()
                const structureName = 'mystructure:araucaria_trapdoor'
                const { x, y, z } = block.location
                world.structureManager.place(structureName, e.dimension, { x, y, z })
                const newBlock = e.dimension.getBlock({ x, y, z })
                const newStates = { ...newBlock.permutation.getAllStates(), ...currentStates }
                const newPermutation = BlockPermutation.resolve(newBlock.typeId, newStates)
                newBlock.setPermutation(newPermutation);
            }
        },
        onTick(e) {
            const { block } = e
            const { x, y, z } = block.location
            const blockKey = `${x},${y},${z}`
            const currentState = block.permutation.getState('v360:open')
            const sound = currentState ? 'open.wooden_trapdoor' : 'close.wooden_trapdoor'
            const adjacentBlocks = {
                north: block.north(),
                east: block.east(),
                south: block.south(),
                west: block.west(),
                above: block.above(),
                below: block.below()
            }
            const excludedBlocks = [
                block.typeId.includes('door'), block.typeId.includes('trapdoor'), 'minecraft:observer', 'minecraft:unpowered_repeater',
                'minecraft:powered_repeater', 'minecraft:unpowered_comparator', 'minecraft:powered_comparator'
            ]
            const hasRedstonePower = Object.values(adjacentBlocks).some(adjacentBlock =>
                !excludedBlocks.includes(adjacentBlock?.typeId) && adjacentBlock?.getRedstonePower() > 0
            )
            const isRedstoneTorchTop = adjacentBlocks.above?.typeId === 'minecraft:redstone_torch' &&
                adjacentBlocks.above.permutation.getState('torch_facing_direction') === 'top'
            const destroyableBlocksArray = [
                block.typeId.includes('button'), block.typeId.includes('pressure_plate')
            ]
            const destroyableBlocks = destroyableBlocksArray.includes(adjacentBlocks.above?.typeId) &&
                adjacentBlocks.above?.getRedstonePower() > 0
            const observerFacingBlock = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' },
                { block: adjacentBlocks.above, direction: 'up' },
                { block: adjacentBlocks.below, direction: 'down' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:observer' &&
                block?.permutation.getState('minecraft:facing_direction') === direction && block?.getRedstonePower() > 1)
            const poweredRepeater = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:powered_repeater' &&
                block?.permutation.getState('minecraft:cardinal_direction') === direction)
            const poweredComparator = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:powered_comparator' &&
                block?.permutation.getState('minecraft:cardinal_direction') === direction)
            const previousState = blockStates.get(blockKey) || false
            const shouldOpen = (hasRedstonePower || observerFacingBlock || poweredRepeater || poweredComparator) && !previousState && !isRedstoneTorchTop;
            const shouldClose = (!hasRedstonePower && !observerFacingBlock && !poweredRepeater && !poweredComparator) && previousState && !isRedstoneTorchTop
            if (shouldOpen || shouldClose) {
                const newState = shouldOpen;
                block.setPermutation(block.permutation.withState('v360:open', newState))
                block.dimension.playSound(sound, block.location)
                blockStates.set(blockKey, newState)
                if (destroyableBlocks) {
                    block.dimension.runCommand(`setblock ${x} ${y + 1} ${z} air destroy`)
                }
            }
        }
    })
})